# Test  histogram verified 2020-05-16
import pygame

title = "Grades for Art 315"
ncategories = 6
maxsize = 20
hlabel = "Grade"
vlabel = "Number of Students"
val = (2, 1, 4, 15, 10, 5)
lab = ("Other", "F", "D", "C", "B", "A")

# Draw a text string at the given point.                       **
def text (s, x, y, size=14, f=None):
    if f == None:                   # Create a font if needed
        f = pygame.font.SysFont(None, size)
    text = f.render(s, 1, (0,0,0))  # Render the string in black
    screen.blit(text, (x, y))

def textsize (s, size=14, f=None):
    if f == None:                   # Create a font if needed
        f = pygame.font.SysFont(None, size)
    text = f.render(s, 1, (0,0,0))  # Render the string in black
    x = text.get_size()[0]
    return x

def verticalLabel(v):
    lasti = 0
    x = 12
    y = 200
    for i in range(0, len(v)):
        if (v[i] == " "):
            text (v[lasti:i], x, y)
            y = y + 20
            lasti = i
    text (v[lasti:], x, y)

width = 600
height = 600
screen = pygame.display.set_mode((width, height))
clock = pygame.time.Clock()
pygame.init()
FPS = 10
fontt14 = pygame.font.SysFont("Times", 14)
fontt24 = pygame.font.SysFont("Times", 24)
fonth14 = pygame.font.SysFont("Helvetica", 14)
fonth24 = pygame.font.SysFont("Helvetica", 24)

while True:
    clock.tick(FPS)
    mouseX, mouseY = pygame.mouse.get_pos()
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            quit()

    screen.fill((180, 180, 180))

    pygame.draw.line (screen, (0,0,0), (100,100), (100,500), 4)    # Y Axis
    pygame.draw.line (screen, (0,0,0), (100,500), (500,500), 4)    # X axis
    text(title, 150, 80, 24, fontt24)     # Title

    cx = (400-textsize(hlabel, 14, fontt14)) / 2
    text(hlabel, 100+cx, 530, 14, fontt14)     # Horizontal axis label

    verticalLabel(vlabel)

    wid = (400-10)/ncategories
    ht = 390.0/maxsize
    for i in range(0,ncategories):
        ulx = 100 + i*wid+2
        uly = int(500 - val[i]*ht-0.5)
        pygame.draw.rect (screen, (200, 20, 200), (ulx, uly, wid, val[i]*ht))
        text (str(val[i]), ulx+20, uly-22, 14, fonth14)

    x = 100+2
    for i in range (0,ncategories):
        cx = wid-textsize(lab[i], 14, fonth14)
        text (lab[i], x+cx/2, 510)
        x = x + wid
    pygame.display.update()
